import React, { useState } from "react";
import { useAuth } from "../context/AuthContext";
import { Link, useNavigate } from "react-router-dom";
import Logo from "../image/Digital-Rackup-Logo.png";

export default function Login() {
    const { login, signInWithGoogle } = useAuth();
    const [email, setEmail] = useState("");
    const [password, setPassword] = useState("");
    const [error, setError] = useState("");
    const [loading, setLoading] = useState(false);
    const navigate = useNavigate();

    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            setError("");
            setLoading(true);
            await login(email, password);
            navigate("/");
        } catch (err) {
            setError(err.message);
        }
        setLoading(false);
    };

    const handleGoogleSignIn = async () => {
        try {
            setError("");
            await signInWithGoogle();
            navigate("/");
        } catch (err) {
            setError(err.message);
        }
    };

    return (
        <div style={{
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            height: "100vh",
            padding: "1rem"
        }}>
            <div className="glass-panel" style={{
                padding: "2.5rem",
                width: "100%",
                maxWidth: "420px",
                display: "flex",
                flexDirection: "column",
                alignItems: "center"
            }}>
                <img src={Logo} alt="Logo" style={{ height: "64px", marginBottom: "1.5rem" }} />

                <h2 style={{
                    fontSize: "1.75rem",
                    fontWeight: "700",
                    marginBottom: "0.5rem",
                    textAlign: "center"
                }}>Welcome Back</h2>

                <p style={{ color: "var(--text-muted)", marginBottom: "2rem", textAlign: "center" }}>
                    Sign in to access your dashboard
                </p>

                {error && <div style={{
                    color: "#f87171",
                    marginBottom: "1.5rem",
                    padding: "0.75rem",
                    background: "rgba(239, 68, 68, 0.1)",
                    borderRadius: "8px",
                    width: "100%",
                    fontSize: "0.875rem",
                    border: "1px solid rgba(239, 68, 68, 0.2)"
                }}>{error}</div>}

                <button
                    onClick={handleGoogleSignIn}
                    className="glass-button-secondary"
                    style={{
                        width: "100%",
                        display: "flex",
                        alignItems: "center",
                        justifyContent: "center",
                        gap: "0.75rem",
                        marginBottom: "1.5rem",
                        background: "white",
                        color: "#333"
                    }}
                >
                    <img src="https://www.gstatic.com/firebasejs/ui/2.0.0/images/auth/google.svg" alt="Google" style={{ width: "18px", height: "18px" }} />
                    Sign in with Google
                </button>

                <div style={{
                    display: "flex",
                    alignItems: "center",
                    width: "100%",
                    marginBottom: "1.5rem",
                    color: "var(--text-muted)",
                    fontSize: "0.875rem"
                }}>
                    <div style={{ flex: 1, height: "1px", background: "rgba(255,255,255,0.1)" }}></div>
                    <span style={{ padding: "0 0.5rem" }}>or</span>
                    <div style={{ flex: 1, height: "1px", background: "rgba(255,255,255,0.1)" }}></div>
                </div>

                <form onSubmit={handleSubmit} style={{ width: "100%" }}>
                    <div style={{ marginBottom: "1rem" }}>
                        <label style={{ display: "block", marginBottom: "0.5rem", fontSize: "0.875rem", fontWeight: "500" }}>Email</label>
                        <input
                            type="email"
                            className="glass-input"
                            value={email}
                            onChange={(e) => setEmail(e.target.value)}
                            required
                            placeholder="name@company.com"
                        />
                    </div>
                    <div style={{ marginBottom: "2rem" }}>
                        <label style={{ display: "block", marginBottom: "0.5rem", fontSize: "0.875rem", fontWeight: "500" }}>Password</label>
                        <input
                            type="password"
                            className="glass-input"
                            value={password}
                            onChange={(e) => setPassword(e.target.value)}
                            required
                            placeholder="••••••••"
                        />
                    </div>
                    <button disabled={loading} className="glass-button" style={{ width: "100%" }} type="submit">
                        {loading ? "Signing In..." : "Sign In"}
                    </button>
                </form>

                <div style={{ marginTop: "1.5rem", textAlign: "center", fontSize: "0.875rem", color: "var(--text-muted)" }}>
                    Don't have an account? <Link to="/register" style={{ color: "var(--accent-primary)", fontWeight: "500", textDecoration: "none" }}>Sign Up</Link>
                </div>
            </div>
        </div>
    );
}
